Rem
Rem $Header: tracedemo.sql 29-dec-2007.09:09:23 nmeng Exp $
Rem
Rem tracedemo.sql
Rem
Rem Copyright (c) 1999, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      tracedemo.sql - Demo program for PL/SQL Trace package
Rem
Rem    DESCRIPTION
Rem    Demo for collecting PL/SQL trace data for simple constructs.
Rem
Rem  REQUIREMENTS
Rem
Rem    o Package DBMS_OUTPUT is installed for the database.
Rem
Rem  NOTES ON EXECUTING THIS DEMO PROGRAM
Rem
Rem    o Create trace related data collection schema using tracetab.sql 
Rem      after connecting as user SYS.
Rem 
Rem    o Load trace package by running dbmspbt.sql, prvtpbt.plb after connecting
Rem      as user SYS. 
Rem
Rem    tracetab.sql, dbmspbt.sql and prvtpbt.sql exist in the
Rem            ORACLE_HOME/rdbms/admin directory.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    nmeng       12/29/07 - use knl_test7
Rem    cwethere    09/18/06 - 5331748: Improve local opts after inlining.
Rem    jmuller     04/09/04 - Fix bug 708690: TAB -> blank 
Rem    rpang       06/24/03 - Do not show sequence number
Rem    jmuller     11/08/01 - Fix bug 2098083: connect internal -> connect sys/
Rem    jmojnida    09/27/99 - Demo for trace facility
Rem    astocks     09/27/99 - Created
Rem

connect scott/tiger
create or replace   PROCEDURE bar2 (flag boolean) IS
   BEGIN
  
     if(flag = true) then
       DBMS_OUTPUT.PUT_LINE('Flag is TRUE');
     else 
       DBMS_OUTPUT.PUT_LINE('Flag is NOT TRUE');
     end if;

  END;

/

show errors

create or replace  PROCEDURE baz (ind number) IS
  counter number;
  BEGIN
 
  FOR counter IN 0..ind LOOP
    DBMS_OUTPUT.PUT_LINE('Inside baz');
  END LOOP;

  END;
/
show errors

create or replace  procedure bar is
  begin
    DBMS_OUTPUT.PUT_LINE('Inside bar');
    baz(8);
    DBMS_OUTPUT.PUT_LINE('Back from baz');
  end;
/
show errors

create or replace  function baz2(flag boolean) return boolean is
  begin
    return (flag);
  end;
/
show errors

create or replace procedure excep(divisor number) is
n  number;
begin
   n := 10/divisor;
   if n > 10e100 then -- Use of n kills optimizer assignment deletion
        dbms_output.put_line('Really big');  -- never executed.
   end if;
end;
/
show errors

create or replace  procedure foo is
b boolean;
  begin
    bar;
    baz(1);
    bar2(baz2(true)); 
    bar2(baz2(false));
    b := baz2(true);
    excep(1);
    excep(0);

  exception
  when ZERO_DIVIDE then
    DBMS_OUTPUT.PUT_LINE('Zero divide');
  end;
/
show errors
  
column stack_depth   format 9999 width 11
column kind          format 9999 width 4
column unit          format a20
column line          format 9999 width 4
column event_comment format a35

set echo on
Rem Run once to get complete trace data at line level
Rem
connect sys/knl_test7 as sysdba
truncate table plsql_trace_events;
connect scott/tiger
execute dbms_trace.set_plsql_trace(dbms_trace.trace_all_lines);
execute foo;
execute dbms_trace.clear_plsql_trace();
connect sys/knl_test7 as sysdba
select stack_depth, event_kind as kind, 
       substr(event_unit,1,20) as unit, event_line as line, event_comment 
         from plsql_trace_events
         order by event_seq;

Rem Run once to get complete trace data for exceptions
Rem
connect sys/knl_test7 as sysdba
truncate table plsql_trace_events;
connect scott/tiger
execute dbms_trace.set_plsql_trace(dbms_trace.trace_all_exceptions);
execute foo;
execute dbms_trace.clear_plsql_trace();
connect sys/knl_test7 as sysdba
select stack_depth, event_kind as kind, 
       substr(event_unit,1,20) as unit, event_line as line, event_comment 
         from plsql_trace_events
         order by event_seq;

Rem Now just get some enabled lines
Rem The should be some "Nodebug lines skipped" records in the output
Rem
connect sys/knl_test7 as sysdba
truncate table plsql_trace_events;
connect scott/tiger
alter procedure foo compile debug;
alter procedure bar compile debug;
alter procedure excep compile debug;
execute dbms_trace.set_plsql_trace(dbms_trace.trace_enabled_lines + dbms_trace.trace_enabled_exceptions);
execute foo;
execute dbms_trace.clear_plsql_trace();
connect sys/knl_test7 as sysdba
select stack_depth, event_kind as kind, 
       substr(event_unit,1,20) as unit, event_line as line, event_comment 
         from plsql_trace_events
         order by event_seq;


